﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class RegistrantHistoryToDeploymentMapperTests : DeploymentFactoryTestBase
    {
        private RegistrantHistoryToDeploymentMapper cut;
        private RegistrantHistory registrantHistory;
        [TestInitialize]
        public void Init()
        {
            cut = new RegistrantHistoryToDeploymentMapper();
            registrantHistory = new RegistrantHistory();
        }
        [TestMethod]
        public void SetDeploymentOccupations_Returns_Empty_List_When_No_DeploymentDates_Do_Not_OverLap_With_Occupation_Dates()
        {

            
            //DateRange of "3/31/2014" to Now
            registrantHistory.OccupationsByDateTime = CreateSingleOccupationHistoryEntry();
            var deploymentDateRange = new DateRange(DateTime.Parse("2005-11-01"), DateTime.Parse("2006-11-29"));
           var actual = cut.SetDeploymentOccupations(registrantHistory,  deploymentDateRange);
            Assert.AreEqual(0, actual.Count);
        }

        [TestMethod]
        public void SetDeploymentOccupations_Returns_List_Of_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_When_DeploymentDates_Match_Occupation_Dates()
        {
            //DateRange of "3/31/2014" to Now. Contains two Occupations
            registrantHistory.OccupationsByDateTime = CreateSingleOccupationHistoryEntry();
            var deploymentDateRange = new DateRange(DateTime.Parse("2014-11-01"), DateTime.Parse("2016-11-29"));
            var actual = cut.SetDeploymentOccupations(registrantHistory, deploymentDateRange);
            Assert.AreEqual(2, actual.Count);
        }

        [TestMethod]
        public void GetPayGradeHistoryForDateRange_Returns_Not_Null_If_Given_Correct_Data()
        {
            DateRange deploymentsByDateRange = new DateRange(DateTime.Parse("2008-11-01"), DateTime.Parse("2010-11-29"));
            registrantHistory.PaymentDataByDateTime = CreateSinglePayGradeHistoryDataEntry();

            var actual = cut.GetPayGradeHistoryForDateRange(registrantHistory, deploymentsByDateRange);
            Assert.IsNotNull(actual);
        }

        [TestMethod]
        public void GetPayGradeHistoryForDateRange_PayGradeHistoryData_For_Correct_DateRange()
        {
            DateRange deploymentsByDateRange = new DateRange(DateTime.Parse("2008-11-01"), DateTime.Parse("2010-11-29"));
            registrantHistory.PaymentDataByDateTime = CreateSinglePayGradeHistoryDataEntry();

            var actual = cut.GetPayGradeHistoryForDateRange(registrantHistory, deploymentsByDateRange);
            Assert.AreEqual("SGT", actual.serviceRankNameCode);
        }

        [TestMethod]
        public void GetPayGradeHistoryForDateRange_Returns_Null_If_Given_INCorrect_Data()
        {
            DateRange nonMatchingDateRange = new DateRange(DateTime.Parse("2008-11-01"), DateTime.Parse("2008-11-29"));
            registrantHistory.PaymentDataByDateTime = CreateSinglePayGradeHistoryDataEntry();

            var actual = cut.GetPayGradeHistoryForDateRange(registrantHistory, nonMatchingDateRange);
            Assert.IsNull(actual);
        }

        [TestMethod]
        public void GetPayGradeHistoryForDateRange_Returns_Latest_PayGradeHistory_With_Latest_Date_If_Multiple_Matches_In_DateRange()
        {
            DateRange deploymentsByDateRange = new DateRange(DateTime.Parse("2008-11-01"), DateTime.Parse("2010-11-29"));
            registrantHistory.PaymentDataByDateTime = CreateTwoPayGradeHistoryDataEntries();

            var actual = cut.GetPayGradeHistoryForDateRange(registrantHistory, deploymentsByDateRange);
            Assert.AreEqual("SSGT", actual.serviceRankNameCode);
        }

    }
}
